<?php

namespace App\Http\Controllers\Admin;

use App\Ads;
use App\Http\Controllers\Controller;
use Input;
use Session;

class AdsController extends Controller
{

    public function create()
    {
        return view('admin.ads.create');
    }

    public function store()
    {

        if (!Input::has('code') | !Input::has('position')) {
            Session::flash('error_msg', 'Code and Position is required');
            return redirect()->back()->withInput(Input::all());
        }

        $ads = new Ads();
        $ads->code = Input::get('code');
        $ads->position = Input::get('position');
        $ads->save();

        Session::flash('success_msg', 'Ad created successfully');
        return redirect()->to('/admin/ads/all');

    }

    public function edit($id = 0)
    {

        $ad = Ads::where('id', $id)->first();

        if (!empty($ad)) {

            return view('admin.ads.edit', ['ad' => $ad]);

        } else {

            Session::flash('error_msg', 'Ad not found');
            return redirect()->to('/admin/ads/all');

        }

    }

    public function delete($id = 0)
    {
        $ad = Ads::where('id', $id)->first();

        if (!empty($ad)) {

            Ads::where('id', $id)->delete();

            Session::flash('success_msg', 'Ad deleted successfully');
            return redirect()->to('/admin/ads/all');

        } else {
            Session::flash('error_msg', 'Ad not found');
            return redirect()->to('/admin/ads/all');
        }
    }

    public function update()
    {

        if (Input::has('id') && sizeof(Ads::where('id', Input::get('id'))->get()) > 0) {


            $ad = Ads::where('id', Input::get('id'))->first();

            $ad->code = Input::get('code');
            $ad->position = Input::get('position');
            $ad->save();

            Session::flash('success_msg', 'Ad updated successfully');
            return redirect()->to('/admin/ads/all');

        } else {
            Session::flash('error_msg', 'Ad not found');
            return redirect()->to('/admin/ads/all');
        }

    }

    public function all()
    {

        $ads = Ads::all();

        return view('admin.ads.all', ['ads' => $ads]);
    }

}